#include <algorithm>
#include <iostream>
#include <sstream>
#include <vector>
#include <string>
#include <set>
#include <map>
#include <iterator>
#include <cmath>
#include <cstdlib>
#include <cstdio>
#include <cstring>
#include <cctype>

using namespace std;

#define FOR(i, a, b) for (int i = (a); i < (b); ++i)
#define ROF(i, a, b) for (int i = (b) - 1; i >= (a); --i)

typedef pair <int, int> pii;
typedef long long LL;
typedef LL ll;

const int INF = 1000000000;
const LL LINF = (LL) INF * (LL) INF;

int n, timer = 0;
vector <vector <int>> graph;
vector <int> best, tIn, f;
vector <bool> used;
vector <set <int> > answer;

void dfs(int v, int parent) {
  used[v] = true;
  tIn[v] = timer++;
  f[v] = tIn[v];

  for (int i = 0; i != graph[v].size(); ++i) {
    if (!used[graph[v][i]]) {
      dfs(graph[v][i], v);
      f[v] = min(f[v], f[graph[v][i]]);

      bool ok = false;
      if (v < n)
        ok = best[v] == graph[v][i];
      else
        ok = best[graph[v][i]] == v;

      if (f[graph[v][i]] <= tIn[v] || ok) {
        if (v < n) {        
          answer[v].insert(graph[v][i]);
        } else {
          answer[graph[v][i]].insert(v);
        }
      }
    } else if (graph[v][i] != parent) {
      f[v] = min(f[v], tIn[graph[v][i]]);
      if (v < n) {        
        answer[v].insert(graph[v][i]);
      } else {
        answer[graph[v][i]].insert(v);
      }
    }     
  } 
}

int main() {
  cin >> n;

  graph.resize(2 * n);
  used.resize(2 * n, false);
  tIn.resize(2 * n);
  f.resize(2 * n);
  answer.resize(n);

  for (int i = 0; i != n; ++i) {
    int curr;
    cin >> curr;

    for (int j = 0; j != curr; ++j) {
      int girl;
      cin >> girl;
      graph[i].push_back(n + girl - 1);
      graph[n + girl - 1].push_back(i);
    }
  }

  best.resize(n);
  for (int i = 0; i != n; ++i) {
    cin >> best[i];
    best[i] += n - 1;
  }

  for (int i = 0; i != 2 * n; ++i) {
    if (!used[i]) {
      dfs(i, -1);
    }
  }

  for (int i = 0; i != n; ++i) {
    cout << answer[i].size() << ' ';
    for (auto it = answer[i].begin(); it != answer[i].end(); ++it) {
      cout << *it + 1 - n << ' ';
    }

    cout << '\n';
  }

  return 0;
}